/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.interfaces.pushbox;

import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import xaero.common.interfaces.pushbox.IPotionEffectsPushBox;
import xaero.common.interfaces.pushbox.PushBox;

public class PotionEffectsPushBox
extends PushBox
implements IPotionEffectsPushBox {
    private boolean hasNegative;

    public PotionEffectsPushBox() {
        super(0, 0, 0, 0, 1.0f, 0.0f, 53);
    }

    @Override
    public int getX(int width, int height) {
        return super.getX(width, height) - this.getW(width, height);
    }

    @Override
    public void update() {
        super.update();
        this.hasNegative = false;
        this.w = PotionEffectsPushBox.calculatePotionDisplayWidth(this);
        this.h = this.hasNegative ? 53 : 27;
    }

    @Override
    public void postUpdate() {
        super.postUpdate();
        this.active = false;
    }

    protected static int calculatePotionDisplayWidth(IPotionEffectsPushBox potionEffectBox) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        Collection collection = player.func_70651_bq();
        if (collection == null || collection.isEmpty()) {
            return 0;
        }
        int positiveCount = 0;
        int negativeCount = 0;
        for (PotionEffect effectInstance : collection) {
            Potion effect = effectInstance.func_188419_a();
            if (effect == null || !effect.shouldRenderHUD(effectInstance) || !effectInstance.func_188418_e()) continue;
            if (!effect.func_188408_i()) {
                potionEffectBox.setHasNegative(true);
                ++negativeCount;
                continue;
            }
            ++positiveCount;
        }
        if (positiveCount + negativeCount == 0) {
            return 0;
        }
        return Math.max(positiveCount, negativeCount) * 25 + 1;
    }

    @Override
    public void setHasNegative(boolean b) {
        this.hasNegative = b;
    }
}

